//
//  NSApplication+MCReportDelegation.h
//  MCReporting
//
//  Created by Alykhan Jetha on 01/10/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <AppKit/AppKit.h>

@class MCPDocument;
@class MCReportWrapper;

@interface NSApplication (MCReportDelegation)

/*! used then generating a report in test mode - we need a way to get the right objectContext in a multi document class app
 */
- (MCPDocument *)documentForReportGenerator;

/*!
 Gives the app the ability to add extra arguments right before the report *simulation* will be run. For example in Billings Pro, the defaultIdentity would be added to the arguments.
 */
- (void)prepareReportArguments:(NSMutableDictionary *)arguments forReportSimulation:(MCReportWrapper *)aReport;
@end
